% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve_ts_overlap.R
\name{resolve_ts_overlap}
\alias{resolve_ts_overlap}
\title{Concatenate Time Series and Resolve Overlap Automatically}
\usage{
resolve_ts_overlap(ts1, ts2, keep_ts2 = T, tolerance = 0.001)
}
\arguments{
\item{ts1}{ts time series, typically the older series}

\item{ts2}{ts time series, typically the younger series}

\item{keep_ts2}{logical should ts2 be kept? Defaults to TRUE.}

\item{tolerance}{numeric when comparing min and max values with a index vector of a time series R runs in to trouble with precision handling, thus a tolerance needs to be set. Typically this does not need to be adjusted. E.g. 2010 != 2010.000. With the help of the tolerance parameter these two are equal.}
}
\description{
Append time series to each other. Resolve overlap determines
 which of two ts class time series is
reaching further and arranges the two series into first and second
series accordingly. Both time series are concatenated to one
if both series had the same frequency. Typically this function is used
concatenate two series that have a certain overlap, but one series clearly
starts earlier while the other lasts longer. If one series starts earlier and
stops later, all elements of the shorter series will be inserted into the
larger series, i.e. elements of the smaller series will replace the elements
of the longer series. Usually ts2 is kept.
}
\examples{
ts1 <- ts(rnorm(100), start = c(1990, 1), frequency = 4)
ts2 <- ts(1:18, start = c(2000, 1), frequency = 4)
resolve_ts_overlap(ts1, ts2)

# automatical detection of correction sequence!
ts1 <- ts(rnorm(90), start = c(1990, 1), frequency = 4)
ts2 <- ts(1:60, start = c(2000, 1), frequency = 4)
resolve_ts_overlap(ts1, ts2)

# both series are of the same length use sequence of arguments.
ts1 <- ts(rnorm(100), start = c(1990, 1), frequency = 4)
ts2 <- ts(1:48, start = c(2003, 1), frequency = 4)
resolve_ts_overlap(ts1, ts2)
ts1 <- ts(rnorm(101), start = c(1990, 1), frequency = 4)
ts2 <- ts(1:61, start = c(2000, 1), frequency = 4)
resolve_ts_overlap(ts1, ts2)
#' clearly dominatn ts2 series
ts1 <- ts(rnorm(50), start = c(1990, 1), frequency = 4)
ts2 <- ts(1:100, start = c(1990, 1), frequency = 4)
resolve_ts_overlap(ts1, ts2)
}
