% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.tvcure.R
\name{AIC.tvcure}
\alias{AIC.tvcure}
\title{Akaike Information Criterion (AIC) of a tvcure object.}
\usage{
\method{AIC}{tvcure}(object, ..., k=2)
}
\arguments{
\item{object}{A \code{\link{tvcure.object}}.}

\item{...}{Other optional tvcure objects.}

\item{k}{The penalty per parameter to be used. (Default: k=2 for the classical AIC).}
}
\value{
The AIC as a numeric value, computed according to the model specified in the input \code{object}.
}
\description{
Akaike Information Criterion (AIC) for the fitted tvcure model in a \code{tvcure.object}.
}
\details{
Akaike information criterion for the fitted model in a tvcure object, with a penalty calculated using the total effective degrees of freedom, -2log(L) + 2*ED.tot, smaller values being preferred during model selection.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
AIC(model)
}

}
\references{
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\seealso{
\code{\link{tvcure}}, \code{\link{tvcure.object}}, \code{\link{BIC.tvcure}}, \code{\link{logEvid}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
