% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvYearAnnuityCompQuarterly.R
\name{pvYearlyAnnuityCompQuarterly}
\alias{pvYearlyAnnuityCompQuarterly}
\title{Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.}
\usage{
pvYearlyAnnuityCompQuarterly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}
}
\description{
Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.
}
\details{
As explained by \insertCite{humm;textual}{tvmComp}, the description of the compounding frequency is usually contained within the phrase that describes the nominal interest rate. An example would be 8 percent compounded quarterly This means that the nominal, or annual, interest rate of 8 percent is compounded four times each year at 8/4 that is 2 percent, each period.
So the method \code{pvYearlyAnnuityCompQuarterly()} is developed to Compute Present Value(PV) of Yearly Paid Ordinary Annuity or Annuity Due that is compounded Quarterly.The method gives PV when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years,\code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments).
}
\examples{
pvYearlyAnnuityCompQuarterly(0.11,4,-300,0)
pvYearlyAnnuityCompQuarterly(0.11,4,-300,1)
pvYearlyAnnuityCompQuarterly(0.11,4,300,0)
pvYearlyAnnuityCompQuarterly(0.11,4,300,1)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP. Kumar, \email{maheshparamjitkumar@gmail.com}
}
