% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{followup.time}
\alias{followup.time}
\title{followup.time}
\usage{
followup.time(
  dat,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  followup.name = "followup.time",
  calculate.as = "total",
  append.to.data = FALSE
)
}
\arguments{
\item{dat}{A data.frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}

\item{followup.name}{The character name for the new variable to display the calculated
follow-up time for each subject.}

\item{calculate.as}{A character value specifying the calculation method for follow-up time:
"max" for the maximum observed time point for each subject, or "total" for the total observed
time across all records for each subject (default). Note: "max" and "total" yield the same
result when records start at time 0, have no gaps, and don't overlap.}

\item{append.to.data}{A logical indicating whether to append the calculated follow-up time
as a new column to the original data.frame (TRUE), or return it as a separate data frame (FALSE, default).}
}
\value{
Returns a modified version of the input data frame or a new data frame based on the
append.to.data parameter. If append.to.data is TRUE, the original data frame is returned with an
additional column named as specified by followup.name, containing the calculated follow-up times
for each subject. If FALSE, a new data frame is returned containing the id.name and the calculated
follow-up times under the followup.name column. This functionality is essential for analyses that
require understanding the duration of subject participation or observation within the study period.
}
\description{
Computes the total or maximum follow-up time for each subject in a panel data structure,
accounting for observation endpoints like death, loss to follow-up, or study conclusion.
}
