% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power2BinaryApprox.R
\name{power2BinaryApprox}
\alias{power2BinaryApprox}
\title{Power Calculation for Two Co-Primary Binary Endpoints (Approximate)}
\usage{
power2BinaryApprox(n1, n2, p11, p12, p21, p22, rho1, rho2, alpha, Test)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{p11}{True probability of responders in group 1 for the first outcome (0 < p11 < 1)}

\item{p12}{True probability of responders in group 1 for the second outcome (0 < p12 < 1)}

\item{p21}{True probability of responders in group 2 for the first outcome (0 < p21 < 1)}

\item{p22}{True probability of responders in group 2 for the second outcome (0 < p22 < 1)}

\item{rho1}{Correlation between the two outcomes for group 1}

\item{rho2}{Correlation between the two outcomes for group 2}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{Test}{Statistical testing method. One of:
\itemize{
\item \code{"AN"}: Asymptotic normal method without continuity correction
\item \code{"ANc"}: Asymptotic normal method with continuity correction
\item \code{"AS"}: Arcsine method without continuity correction
\item \code{"ASc"}: Arcsine method with continuity correction
}}
}
\value{
A data frame with the following columns:
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{p11, p12, p21, p22}{Response probabilities}
\item{rho1, rho2}{Correlations}
\item{alpha}{One-sided significance level}
\item{Test}{Testing method used}
\item{power1}{Power for the first endpoint alone}
\item{power2}{Power for the second endpoint alone}
\item{powerCoprimary}{Power for both co-primary endpoints}
}
\description{
Calculates the power for a two-arm superiority trial with two co-primary
binary endpoints using various asymptotic normal approximation methods, as
described in Sozu et al. (2010).
}
\details{
This function implements four approximate power calculation methods:

\strong{Asymptotic Normal (AN):} Uses the standard normal approximation without
continuity correction (equations 3-4 in Sozu et al. 2010).

\strong{Asymptotic Normal with Continuity Correction (ANc):} Includes Yates's
continuity correction (equation 5 in Sozu et al. 2010).

\strong{Arcsine (AS):} Uses arcsine transformation without continuity correction
(equation 6 in Sozu et al. 2010).

\strong{Arcsine with Continuity Correction (ASc):} Arcsine method with continuity
correction (equation 7 in Sozu et al. 2010).

The correlation between test statistics for the two endpoints depends on the method:

\strong{For AN and ANc methods:}
\deqn{\rho_{nml} = \frac{\sum_{j=1}^{2} \rho_j \sqrt{\nu_{j1}\nu_{j2}}/n_j}
      {se_1 \times se_2}}
where \eqn{\nu_{jk} = p_{jk}(1-p_{jk})}.

\strong{For AS method:}
\deqn{\rho_{arc} = \frac{n_2 \rho_1 + n_1 \rho_2}{n_1 + n_2}}
This is the weighted average of the correlations from both groups.

\strong{For ASc method:}
\deqn{\rho_{arc,c} = \frac{1}{se_1 \times se_2}
      \left(\frac{\rho_1 \sqrt{\nu_{11}\nu_{12}}}{4n_1\sqrt{\nu_{11,c}\nu_{12,c}}} +
      \frac{\rho_2 \sqrt{\nu_{21}\nu_{22}}}{4n_2\sqrt{\nu_{21,c}\nu_{22,c}}}\right)}
where \eqn{\nu_{jk,c} = (p_{jk} + c_j)(1 - p_{jk} - c_j)},
\eqn{c_1 = -1/(2n_1)}, and \eqn{c_2 = 1/(2n_2)}.

The correlation bounds are automatically checked using \code{\link{corrbound2Binary}}.
}
\examples{
# Power calculation using asymptotic normal method
power2BinaryApprox(
  n1 = 200,
  n2 = 100,
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.7,
  rho2 = 0.7,
  alpha = 0.025,
  Test = 'AN'
)

# Power calculation with continuity correction
power2BinaryApprox(
  n1 = 200,
  n2 = 100,
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.7,
  rho2 = 0.7,
  alpha = 0.025,
  Test = 'ANc'
)

# Power calculation using arcsine method
power2BinaryApprox(
  n1 = 150,
  n2 = 150,
  p11 = 0.6,
  p12 = 0.5,
  p21 = 0.4,
  p22 = 0.3,
  rho1 = 0.5,
  rho2 = 0.5,
  alpha = 0.025,
  Test = 'AS'
)

}
\references{
Sozu, T., Sugimoto, T., & Hamasaki, T. (2010). Sample size determination in
clinical trials with multiple co-primary binary endpoints. \emph{Statistics in
Medicine}, 29(21), 2169-2179.
}
