% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{chisq}
\alias{chisq}
\title{Pearson's chi-squared test}
\usage{
chisq(.data, exposure, outcome, correct = TRUE, ...)
}
\arguments{
\item{.data}{Either a data frame with observation-level exposure and outcome data or a \link[twoxtwo]{twoxtwo} object}

\item{exposure}{Name of exposure variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{outcome}{Name of outcome variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{correct}{Logical as to whether or not to apply continuity correction; default is \code{TRUE}}

\item{...}{Additional arguments passed to \link[twoxtwo]{twoxtwo} function; ignored if input to \code{.data} is a \code{twoxtwo} object}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \strong{test}: Name of the test conducted
\item \strong{estimate}: Point estimate from the test (\code{NA} for \code{chisq()})
\item \strong{ci_lower}: The lower bound of the confidence interval for the estimate (\code{NA} for \code{chisq()})
\item \strong{ci_upper}: The upper bound of the confidence interval for the estimate (\code{NA} for \code{chisq()})
\item \strong{statistic}: Test statistic from the test
\item \strong{df}: Degrees of freedom parameter for the test statistic
\item \strong{pvalue}: P-value from the test
\item \strong{exposure}: Name of the exposure variable followed by +/- levels (e.g. smoking::yes/no)
\item \strong{outcome}: Name of the outcome variable followed by +/- levels (e.g. heart_disease::yes/no)
}
}
\description{
This function conducts a Pearson's chi-squared test for a \code{twoxtwo} constructed using the specified exposure and outcome. Internally the function uses \link[stats]{chisq.test}. The output of the function includes the chi-squared test statistic, degrees of freedom, and the p-value from the test.
}
