% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{var2string}
\alias{var2string}
\title{Converts Numeric Variables into Padded Strings}
\usage{
var2string(vars, maxlength = 0, nsig_e = 3, nsig_f = 4)
}
\arguments{
\item{vars}{numeric variable or a vector of numeric variables}

\item{maxlength}{if this value is greater than zero spaces will be added to the beginning of the string until the total length is equal to maxlength}

\item{nsig_e}{number of significant figures for scientific notation}

\item{nsig_f}{number of significant figures for numbers (2.123)}
}
\value{
Number as a string padded
}
\description{
Mechanism for converting numeric variables into strings for reporting.
}
\examples{
var2string(pi, nsig_f=20)
var2string(.0001121, nsig_e=2, maxlength=10)
}
