% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{UmiCountsPlot}
\alias{UmiCountsPlot}
\title{Plot UMI counts}
\usage{
UmiCountsPlot(
  object,
  amplicons = NULL,
  samples = NULL,
  theme = "classic",
  option = "viridis",
  direction = 1
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{amplicons}{(Optional) user-supplied list of assays to plot. Default is all.}

\item{samples}{(Optional) user-supplied list of samples to plot. Default is all.}

\item{theme}{Plotting theme, default is classic}

\item{option}{Color palette. Default uses ggplot standard, otherwise viridis options.}

\item{direction}{If using viridis colors should the scale be inverted or default?}
}
\value{
A UMIexperiment object
}
\description{
Visualize the number detected UMI for each consensus depth cut-off. This may
may helpful in choosing the right consensus depth for your analysis, by
checking the number of reads still available for each assay and sample
for your chosen cut-off.
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')
samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)
simsen <- createUmiExperiment(experimentName = 'example',mainDir = main,sampleNames = samples)
simsen <- filterUmiObject(simsen)

count_plot <- UmiCountsPlot(simsen)

}
