% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{createUmiExperiment}
\alias{createUmiExperiment}
\title{Method for creating a UMI experiment object}
\usage{
createUmiExperiment(
  mainDir,
  experimentName = NULL,
  sampleNames = NULL,
  importBam = FALSE,
  as.shiny = FALSE
)
}
\arguments{
\item{mainDir}{Main experiment directory}

\item{experimentName}{Name of the experiment}

\item{sampleNames}{List of sample names. Can be either NULL or list. If NULL all subdirectories of mainDir will be searched.}

\item{importBam}{Logical. Should bam files be imported on creation? Default is False.}

\item{as.shiny}{Set to TRUE if run within a shiny::withProgress environment}
}
\value{
An object of class UMIexperiment
}
\description{
Method for creating a UMI experiment object
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')

samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)

exp1 <- createUmiExperiment(experimentName = 'exp1',mainDir = main,sampleNames = samples)

}
