% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_effective_bets.R
\name{max_effective_bets}
\alias{max_effective_bets}
\title{Risk-Diversification powered by the Minimum Torsion Algorithm}
\usage{
max_effective_bets(x0, sigma, t, tol = 1e-20, maxeval = 5000L, maxiter = 5000L)
}
\arguments{
\item{x0}{A \code{numeric} vector for the search starting point. Usually the
"one over n" allocation.}

\item{sigma}{A \code{n x n} covariance matrix.}

\item{t}{A \code{n x n} torsion matrix.}

\item{tol}{An \code{interger} with the convergence tolerance.}

\item{maxeval}{An \code{integer} with the maximum number of evaluations of the
objective function.}

\item{maxiter}{An \code{integer} with the maximum number of iterations.}
}
\value{
A \code{list} with the following components:
    \itemize{
      \item \code{weights}: the optimal allocation policy
      \item \code{enb}: the optimal effective number of bets
      \item \code{counts}: the number of iterations of the objective and the gradient
      \item \code{lambda_lb}: the lower bound Lagrange multipliers
      \item \code{lambda_ub}: the upper bound Lagrange multipliers
      \item \code{lambda_eq}: the equality Lagrange multipliers
      \item \code{gradient}: the gradient of the objective function at the optimum
      \item \code{hessian}: hessian of the objective function at the optimum
    }
}
\description{
Finds the allocation that maximizes the \code{\link{effective_bets}}.
}
\examples{
# extract the invariants from the data
set.seed(123)
log_ret <- matrix(stats::rnorm(400), ncol = 4) / 10

# compute the covariance matrix
sigma <- stats::cov(log_ret)

# torsion
torsion_cov <- torsion(sigma = sigma, model = 'minimum-torsion', method = 'exact')

# 1/N reference
b <- rep(1 / ncol(log_ret), ncol(log_ret))

max_effective_bets(x0 = b, sigma = sigma, t = torsion_cov)
}
\seealso{
\code{\link[NlcOptim]{solnl}}
}
