% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_page.R
\name{html_page}
\alias{html_page}
\title{Convert to UNHCR branded HTML website}
\usage{
html_page(...)
}
\arguments{
\item{...}{extra parameters to pass to \code{rmarkdown::html_document}}
}
\value{
An R Markdown output format.
}
\description{
Format for converting from R Markdown to an UNHCR branded HTML website
}
\examples{
\dontrun{
# Requires pandoc

# Create an R Markdown example file
rmd_content <- "---
 title: 'Example UNHCR HTML Page'
 output: unhcrdown::html_page
 ---

 ## Introduction

 This is an example of a UNHCR-branded HTML page created using `unhcrdown::html_page`.
 "

# Write the R Markdown content to a file
example_file <- tempfile(fileext = ".Rmd")
writeLines(rmd_content, example_file)

# Render the R Markdown file
rmarkdown::render(example_file,
  output_format = unhcrdown::html_page(),
  output_dir = tempdir()
)

# View the rendered HTML file
browseURL(render_file)
}
}
