% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.classification.R
\name{risk.classification}
\alias{risk.classification}
\title{The risk ranks of the samples predicted by a tree}
\usage{
risk.classification(tree, X.mat)
}
\arguments{
\item{tree}{:an object made from the "uni.tree" function}

\item{X.mat}{:n by p matrix of covariates from the samples, where n is the sample size and p is the number of covariates}
}
\value{
A vector of integers, 1, 2, ..., k, that represent the ranks predicted for the samples.
}
\description{
The function returns the ranks (1=the lowest risk, 2=the 2nd lowest risk, ...,  k=the highest risk) predicted for the samples.
}
\details{
If the tree has k terminal nodes, then the response 1 respresents the lowest risk and k represents the highest risk.
}
\examples{
data(Lung,package="compound.Cox")
train_Lung=Lung[which(Lung[,"train"]==TRUE),] #select training data
t.vec=train_Lung[,1]
d.vec=train_Lung[,2]
x.mat=train_Lung[,-c(1,2,3)]
res=uni.tree(t.vec,d.vec,x.mat,P.value=0.01,d0=0.01,S.plot=FALSE,score=TRUE)
risk.classification(res,x.mat)
}
