% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bangor.R
\docType{data}
\name{bangor_3}
\alias{bangor_3}
\title{Tertiary colours of the University of Bangor, Wales}
\format{
An object of class \code{character} of length 8.
}
\source{
Colour definitions are based on \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines (PDF).
}
\usage{
bangor_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bangor_3} provides eight tertiary colours 
of the \href{https://www.bangor.ac.uk}{University of Bangor}, Wales, UK.
}
\details{
\code{bangor_3} is based on HEX color definitions  
(see \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines, PDF, p. 10, for names and details).


Motto: Our history, heritage and landscape.

\href{https://www.bangor.ac.uk}{Bangor University} 
is steeped in history and heritage. 
Our location is surrounded by the Snowdonia National Park. 
To reflect these elements we have created a 
subtle palette of colour, which also incorporates our 
environment: stone, slate, sand, water, forest, meadow and sea.

We use this palette to support our primary and secondary colours. 
We do not departmentalise the use of our colourways. 
(See how to use colour, in the ‘Brand Elements’ section 
of \href{https://www.bangor.ac.uk}{Bangor}'s brand guidelines, PDF.)
}
\examples{
bangor_3
unikn::seecol(bangor_3, 
              main = "Tertiary colours of the University of Bangor, Wales")  # view palette

}
\seealso{
\code{\link{bangor_1}} for primary corporate colours of Bangor;
\code{\link{bangor_2}} for secondary colours of Bangor;
\code{\link{bangor_4}} for accessible web colours of Bangor;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-10-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
