% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bangor.R
\docType{data}
\name{bangor_4}
\alias{bangor_4}
\title{Accessible web colours of the University of Bangor, Wales}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines (PDF).
}
\usage{
bangor_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bangor_4} provides four accessible web colours 
of the \href{https://www.bangor.ac.uk}{University of Bangor}, Wales, UK.
}
\details{
\code{bangor_4} is based on HEX color definitions  
(see \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines, PDF, p. 10, for names and details).


\href{https://www.bangor.ac.uk}{Bangor University} 
has created a web-specific palette that reflects 
the environment we are surrounded by: 
Slate grey, Sea green, and tints of yellow and orange.

As some colour combinations can be problematic for people with visual impairments 
or colour blindness, this palette is for everyone to enjoy.
}
\examples{
bangor_4
unikn::seecol(bangor_4, 
              main = "Accessible web colours of Bangor University, Wales")  # view palette

}
\seealso{
\code{\link{bangor_1}} for primary corporate colours of Bangor;
\code{\link{bangor_2}} for secondary colours of Bangor;
\code{\link{bangor_3}} for tertiary colours of Bangor;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-10-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
