% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bergen.R
\docType{data}
\name{bergen_2}
\alias{bergen_2}
\title{Additional colours of the University of Bergen, Norway}
\format{
An object of class \code{character} of length 30.
}
\source{
Colour definitions are based on \href{https://www.uib.no}{UiB}'s 
\href{https://manual.uib.no/en/brand-guide/}{brand guide} (HTML).
}
\usage{
bergen_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bergen_2} provides additional colours 
of the \href{https://www.uib.no}{University of Bergen}, Norway.
}
\details{
\code{bergen_2} is based on HEX color definitions.
}
\examples{
bergen_2
unikn::seecol(bergen_2, 
              main = "Additional colours of the University of Bergen, Norway")  # view palette
              

}
\seealso{
\code{\link{bergen_1}} for main colours of the University of Bergen;
\code{\link{bergen_3}} for support colours of the University of Bergen; 
\code{\link{bergen_4}} for text colours of the University of Bergen; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Norwegian university color palettes: 
\code{\link{bergen_1}},
\code{\link{bergen_3}},
\code{\link{bergen_4}},
\code{\link{oslo}}
}
\author{
\strong{unicol}, 2023-10-11.
}
\concept{Norwegian university color palettes}
\keyword{datasets}
