% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_socialmedia}
\alias{oxford_socialmedia}
\title{Social Media colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 11.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_socialmedia
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_socialmedia} provides the eleven social media colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The 11 social media colours are
\code{"cherry"} (defined as HEX #be0f34),
\code{"purple"} (defined as HEX #ac48bf),
\code{"red"} (defined as HEX #c7302b),
\code{"light_blue"} (defined as HEX #1daced),
\code{"deep_blue"} (defined as HEX #001c3d),
\code{"lagoon_blue"} (defined as HEX #006599),
\code{"weibo"} (defined as HEX #d62a2a),
\code{"green"} (defined as HEX #177770),
\code{"orange"} (defined as HEX #fb8113),
\code{"google_plus"} (defined as HEX #d34836), and
\code{"instagram"} (defined as HEX #517fa4),
}
\examples{
oxford_socialmedia
unikn::seecol(oxford_socialmedia, main = "Uni Oxford social media colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
