% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCDublin.R
\docType{data}
\name{ucd}
\alias{ucd}
\title{Colours of the University College Dublin, Ireland}
\format{
An object of class \code{character} of length 7.
}
\source{
Colour definitions are based on the \href{https://www.ucd.ie}{UCD}'s 
\href{https://silo.tips/download/brand-identity-guidelines}{Brand identity guidelines} 
(PDF, Version 3, 2006) and 
\href{https://www.ucd.ie/websmart/designlibrary-guide/}{CSS} specifications.
}
\usage{
ucd
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ucd} provides seven colours of the 
\href{https://www.ucd.ie}{University College Dublin}, Ireland.
}
\details{
The five primary colours 
\code{UCD blue}, \code{UCD navy}, \code{UCD gold}, \code{UCD rich green}, and \code{UCD bright green}, 
are defined in \href{https://www.ucd.ie}{UCD}'s 
\href{https://silo.tips/download/brand-identity-guidelines}{Brand identity guidelines} 
(PDF, Version 3, 2006).

Two additional colours 
\code{UCD navy dark} and \code{UCD gold light} 
are defined in \href{https://www.ucd.ie}{UCD}'s  
\href{https://www.ucd.ie/websmart/designlibrary-guide/}{CSS} 
specifications (v0.0.1)

\code{ucd} is based on the HEX colour values of the  
\href{https://www.ucd.ie/websmart/designlibrary-guide/}{CSS} specs.
}
\examples{
ucd
unikn::seecol(ucd, main = "Colours of the University College Dublin")  # view colour palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}}
}
\author{
Contributed to \strong{unicol} by Enda Patrick Hargaden, 2023-09-13.
}
\concept{Irish university color palettes}
\keyword{datasets}
