% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun_2.R
\name{ac}
\alias{ac}
\title{Adjust color transparency}
\usage{
ac(col, alpha = 0.5, use_names = TRUE)
}
\arguments{
\item{col}{A (required) color or color palette (as a vector).}

\item{alpha}{A factor modifying the opacity alpha 
(as \code{alpha.f} in \code{\link{adjustcolor}}) to a value in \code{[0, 1]}. 
Default: \code{alpha = .50} (i.e., medium opacity).}

\item{use_names}{A logical value indicating whether color names should be adjusted 
to include the values of \code{alpha}. 
Default: \code{use_names = TRUE}.}
}
\value{
A color vector of the same length as \code{col}, 
transformed by \code{\link{adjustcolor}}.
}
\description{
\code{ac} adjusts the transparency of a color or color palette \code{col} 
to an opacity level \code{alpha} (in \code{[0, 1]}).
}
\details{
\code{ac} is mostly a wrapper for \code{\link{adjustcolor}} 
of the \strong{grDevices} package, but allows for more flexible 
combinations of (multiple) \code{col} and \code{alpha} values. 

The name \code{ac} is an abbreviation of "adjust color", 
but is also a mnemonic aid for providing "air conditioning".
}
\examples{
ac("black")  # using alpha = .5 by default

# multiple colors:
cols <- ac(c("black", "gold", "deepskyblue"), alpha = .50)
seecol(cols, main = "Transparent colors")

# multiple alphas:
blacks <- ac("black", alpha = 5:0/5)
seecol(blacks, main = "One col several alpha values")

bgc <- ac(c("black", "gold"), alpha = 1:6/6)
seecol(bgc, main = "More alpha values than cols")

# Using a color palette:
seecol(ac(pal_unikn_pref, 2/3), main = "Adding color transparency by ac()")

# Color names:
seecol(ac(col = pal_unikn_pref, alpha = c(1/5, 4/5), use_names = TRUE))
seecol(ac(col = pal_unikn_pref, alpha = c(1/5, 4/5), use_names = FALSE))

}
\seealso{
\code{\link{seecol}} for plotting/seeing color palettes; 
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;  
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other color functions: 
\code{\link{demopal}()},
\code{\link{grepal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{shades_of}()},
\code{\link{simcol}()},
\code{\link{usecol}()}
}
\concept{color functions}
