% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpareto.R
\name{mlpareto}
\alias{mlpareto}
\title{Pareto distribution maximum likelihood estimation}
\usage{
mlpareto(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlpareto} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{a} and \code{b} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimate of \code{b} is the minimum of \code{x} and the
maximum likelihood estimate of \code{a} is
\code{1/(mean(log(x)) - log(b))}.
}
\details{
For the density function of the Pareto distribution see
\link[extraDistr:Pareto]{Pareto}.
}
\examples{
mlpareto(precip)
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous
Univariate Distributions, Volume 1, Chapter 20. Wiley, New York.
}
\seealso{
\link[extraDistr:Pareto]{Pareto} for the Pareto density.
}
