% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateme_sources_set.R
\name{updateme_sources_set}
\alias{updateme_sources_set}
\title{Configure updateme lookup of new package versions}
\usage{
updateme_sources_set(...)
}
\arguments{
\item{...}{Named or unnamed arguments. Values should be either:
\itemize{
\item One of \code{names(getOption("repo"))}: latest versions will be taken from
this source, if available
\item \code{"bioc"}: new versions will be looked for on Bioconductor
\item \code{"github"}/\code{"gitlab"}: new versions will looked for on on
GitHub/GitLab, if a repo can be identified using the package
\code{DESCRIPTION}
\item A URL pointing to a GitHub/GitLab repo, e.g.
\code{"https://github.com/wurli/updateme"}: the latest version \emph{for this
particular package} will be taken from this project
\item \code{NA}: updateme will not attempt to query new versions.
Note that \code{NA} inputs must always be named (i.e. you must specify this
'per package')
\item \code{NULL}: return to the default behaviour
}

If arguments are named, names should indicate package which the option
should apply to. If unnamed, the option will apply to all packages. See
examples for more information.}
}
\value{
The result of setting
\verb{options(updateme.sources = <new_options>)}
}
\description{
This function is a helper for setting the \code{"updateme.sources"}
global option. It provides a user-friendly interface and validation of the
options you set.
}
\section{Private Repositories}{

updateme supports packages installed from private repositories on GitHub
and GitLab. To get upstream package version from either, you should only have
to configure a personal access token (PAT):
\itemize{
\item For GitHub packages, updateme checks, in order:
\itemize{
\item The \code{GITHUB_PAT} environmental variable
\item The \code{GITHUB_TOKEN} environmental variable
\item Any personal access tokens configured using \code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_set()}}
}
\item For GitLab packages, updateme checks, in order:
\itemize{
\item The \code{GITLAB_PAT} environmental variable
\item The \code{GITLAB_TOKEN} environmental variable
\item Any personal access tokens configured using \code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_set()}}
}
}
}

\examples{
# If you want to check non-standard repos for new versions of packages,
# you'll first have to set the repos global option. Note that each
# option must be named for compatibility with updateme
old_repos <- options(repos = c(

  # Your default CRAN mirror will likely be something like this
  CRAN = "https://cloud.r-project.org",

  # The r-lib r-universe, including dev versions of infrastructure packages
  # like cli, rlang, etc
  `r-lib` = "https://r-lib.r-universe.dev"
))

# 1. New versions will first be looked up from the r-lib R universe by default
# 2. If not found, they will be looked up from the usual CRAN mirror
# 3. dplyr will always be first looked up from GitHub
# 4. ggplot2 won't be looked up or notified about
old_updateme_sources <- updateme_sources_set(
  "r-lib",
  "CRAN",
  dplyr = "https://github.com/tidyverse/dplyr", # Name is optional here
  ggplot2 = NA
)

# memoise should now be looked up from the r-lib r-universe
if (interactive()) {
  library(memoise)
}

# Restore old options
options(old_repos)
options(old_updateme_sources)
}
\seealso{
\code{\link[=updateme_on]{updateme_on()}} and \code{\link[=updateme_off]{updateme_off()}} to disable updateme for all
packages
}
