% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{us_temp_tbl_df}
\alias{us_temp_tbl_df}
\title{US Temperature Data}
\format{
A tibble with 10,118 rows and 9 columns:
\describe{
  \item{station}{Character string representing the weather station identifier.}
  \item{name}{Character string for the name of the weather station.}
  \item{latitude}{Numeric value for the latitude of the weather station.}
  \item{longitude}{Numeric value for the longitude of the weather station.}
  \item{elevation}{Numeric value for the elevation of the weather station in meters.}
  \item{date}{Date of the recorded temperature data.}
  \item{tmax}{Numeric value for the maximum temperature recorded (in degrees Celsius).}
  \item{tmin}{Numeric value for the minimum temperature recorded (in degrees Celsius).}
  \item{year}{Factor representing the year of the recorded data.}
}
}
\source{
National Oceanic and Atmospheric Administration (NOAA).
}
\usage{
data(us_temp_tbl_df)
}
\description{
The dataset 'us_temp_tbl_df' contains temperature records from various weather stations
across the United States, providing both maximum and minimum temperature readings.
This dataset is structured as a tibble for ease of use within the R ecosystem. This naming
convention helps distinguish this dataset as part of the 'usdatasets' package.
}
