% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vader_df.R
\name{vader_df}
\alias{vader_df}
\title{Get a dataframe of vader results for multiple text documents}
\usage{
vader_df(text, incl_nt = T, neu_set = T, rm_qm = F)
}
\arguments{
\item{text}{to be analyzed; for vader_df(), the text should be a single vector (e.g. 1 column)}

\item{incl_nt}{defaults to T, indicates whether you wish to incl UNUSUAL n't contractions (e.g., yesn't) in negation analysis}

\item{neu_set}{defaults to T, indicates whether you wish to count neutral words in calculations}

\item{rm_qm}{defaults to T, indicates whether you wish to clean quotation marks from text (setting to F may result in errors)}
}
\value{
A dataframe containing the valence score for each word; an overall, compound valence score for the text; the weighted percentage of positive, negative, and neutral words in the text; and the frequency of the word "but".
}
\description{
Use vader_df() to calculate the valence of multiple texts contained within a vector or column in a dataframe.
}
\section{N.B.}{

In the examples below, "yesn't" is an internet neologism meaning "no", "maybe yes, maybe no", "didn't", etc.
}

\seealso{
\code{\link{get_vader}} to get vader results for a single text document
}
