% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tests.R
\name{run_custom_test}
\alias{run_custom_test}
\title{Run a Custom Test using the ValidMind Framework}
\usage{
run_custom_test(test_id, inputs, test_registry, show = FALSE)
}
\arguments{
\item{test_id}{A string representing the ID of the custom test to run.}

\item{inputs}{A list of inputs required for the custom test.}

\item{test_registry}{A reference to the test register object which provides the custom test class.}

\item{show}{A logical value. If TRUE, the result will be displayed. Defaults to FALSE.}
}
\value{
An object representing the result of the test, with an additional log function.
}
\description{
This function runs a custom test using the ValidMind framework through Python's 
`validmind.vm_models`. It retrieves a custom test by `test_id`, executes it with the provided 
`inputs`, and optionally displays the result. The result is also logged.
}
\examples{
\dontrun{
result <- run_custom_test("test123", my_inputs, test_registry, show = TRUE)
}
}
