% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vardchanges.R
\name{vardchanges}
\alias{vardchanges}
\title{Variance estimation for measures of change for single and multistage stage cluster sampling designs}
\usage{
vardchanges(
  Y,
  H,
  PSU,
  w_final,
  ID_level1,
  ID_level2,
  Dom = NULL,
  Z = NULL,
  gender = NULL,
  country = NULL,
  period,
  dataset = NULL,
  period1,
  period2,
  X = NULL,
  countryX = NULL,
  periodX = NULL,
  X_ID_level1 = NULL,
  ind_gr = NULL,
  g = NULL,
  q = NULL,
  datasetX = NULL,
  linratio = FALSE,
  percentratio = 1,
  use.estVar = FALSE,
  outp_res = FALSE,
  confidence = 0.95,
  change_type = "absolute",
  checking = TRUE
)
}
\arguments{
\item{Y}{Variables of interest. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{H}{The unit stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{PSU}{Primary sampling unit variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{w_final}{Weight variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ID_level1}{Variable for level1 ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ID_level2}{Optional variable for unit ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{Dom}{Optional variables used to define population domains. If supplied, variables are calculated for each domain. An object convertible to \code{data.table} or variable names as character vector, column numbers.}

\item{Z}{Optional variables of denominator for ratio estimation. If supplied, the ratio estimation is computed. Object convertible to \code{data.table} or variable names as character, column numbers. This variable is \code{NULL} by default.}

\item{gender}{Numerical variable for gender, where 1 is for males, but 2 is for females. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{country}{Variable for the survey countries. The values for each country are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{period}{Variable for the all survey periods. The values for each period are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{dataset}{Optional survey data object convertible to \code{data.table}.}

\item{period1}{The vector of periods from variable \code{periods} describes the first period.}

\item{period2}{The vector of periods from variable \code{periods} describes the second period.}

\item{X}{Optional matrix of the auxiliary variables for the calibration estimator. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{countryX}{Optional variable for the survey countries. The values for each country are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{periodX}{Optional variable of the all survey periods. If supplied, residual estimation of calibration is done independently for each time period. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{X_ID_level1}{Variable for level1 ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{ind_gr}{Optional variable by which divided independently X matrix of the auxiliary variables for the calibration. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{g}{Optional variable of the g weights. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{q}{Variable of the positive values accounting for heteroscedasticity. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{datasetX}{Optional survey data object in household level convertible to \code{data.table}.}

\item{linratio}{Logical value. If value is \code{TRUE}, then the linearized variables for the ratio estimator is used for variance estimation. If value is \code{FALSE}, then the gradients is used for variance estimation.}

\item{percentratio}{Positive numeric value. All linearized variables are multiplied with \code{percentratio} value, by default - 1.}

\item{use.estVar}{Logical value. If value is \code{TRUE}, then \code{R} function \code{estVar} is used for the  estimation of covariance matrix of the residuals. If value is \code{FALSE}, then \code{R} function \code{estVar} is not used for the  estimation of covariance matrix of the residuals.}

\item{outp_res}{Logical value. If \code{TRUE} estimated residuals of calibration will be printed out.}

\item{confidence}{optional; either a positive value for confidence interval. This variable by default is 0.95 .}

\item{change_type}{character value net changes type - absolute or relative.}

\item{checking}{Optional variable if this variable is TRUE, then function checks data preparation errors, otherwise not checked. This variable by default is TRUE.}
}
\value{
A list with objects are returned by the function:
\itemize{
    \item \code{res_out} - a \code{data.table} containing the estimated residuals of calibration with ID_level1 and PSU by periods and countries (if available).
    #'     \item \code{crossectional_results} - a \code{data.table} containing: \cr
       \code{period} -  survey periods, \cr
       \code{country} - survey countries, \cr
       \code{Dom} - optional variable of the population domains, \cr
       \code{namesY} - variable with names of variables of interest, \cr
       \code{namesZ} - optional variable with names of denominator for ratio estimation, \cr
       \code{sample_size} - the sample size (in numbers of individuals), \cr
       \code{pop_size} - the population size (in numbers of individuals), \cr
       \code{total} - the estimated totals, \cr
       \code{variance} - the estimated variance of cross-sectional or longitudinal measures, \cr
       \code{sd_w} - the estimated weighted variance of simple random sample, \cr
       \code{sd_nw} - the estimated variance estimation of simple random sample, \cr
       \code{pop} - the population size (in numbers of households), \cr
       \code{sampl_siz} - the sample size (in numbers of households), \cr
       \code{stderr_w} - the estimated weighted standard error of simple random sample, \cr
       \code{stderr_nw} - the estimated standard error of simple random sample, \cr
       \code{se} - the estimated standard error of cross-sectional or longitudinal, \cr
       \code{rse} - the estimated relative standard error (coefficient of variation), \cr
       \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
       \code{absolute_margin_of_error} - the estimated absolute margin of error, \cr
       \code{relative_margin_of_error} - the estimated relative margin of error, \cr
       \code{CI_lower} - the estimated confidence interval lower bound, \cr
       \code{CI_upper} - the estimated confidence interval upper bound.
       #'     \item \code{crossectional_var_grad} - a \code{data.table} containing: \cr
       \code{periods} -  survey periods, \cr
       \code{country} - survey countries, \cr
       \code{Dom} - optional variable of the population domains, \cr
       \code{namesY} - variable with names of variables of interest, \cr
       \code{namesZ} - optional variable with names of denominator for ratio estimation, \cr
       \code{grad} - the estimated gradient, \cr
       \code{var} - the estimated a design-based variance.
    \item \code{rho} - a \code{data.table} containing: \cr
       \code{periods_1} -  survey periods of \code{periods1}, \cr
       \code{periods_2} -  survey periods of \code{periods2}, \cr
       \code{country} - survey countries, \cr
       \code{Dom} - optional variable of the population domains, \cr
       \code{namesY} - variable with names of variables of interest, \cr
       \code{namesZ} - optional variable with names of denominator for ratio estimation, \cr
       \code{nams} - the variable names in correlation matrix, \cr
       \code{rho} - the estimated correlation matrix.
   \item \code{var_tau} - a \code{data.table} containing: \cr
       \code{periods_1} -  survey periods of \code{periods1}, \cr
       \code{periods_2} -  survey periods of \code{periods2}, \cr
       \code{country} - survey countries, \cr
       \code{Dom} - optional variable of the population domains, \cr
       \code{namesY} - variable with names of variables of interest, \cr
       \code{namesZ} - optional variable with names of denominator for ratio estimation, \cr
       \code{nams} - the variable names in correlation matrix, \cr
       \code{var_tau} - the estimated covariance matrix.
   \item \code{changes_results} - a \code{data.table} containing: \cr
       \code{periods_1} -  survey periods of \code{periods1}, \cr
       \code{periods_2} -  survey periods of \code{periods2}, \cr
       \code{country} - survey countries, \cr
       \code{Dom} - optional variable of the population domains, \cr
       \code{namesY} - variable with names of variables of interest, \cr
       \code{namesZ} - optional variable with names of denominator for ratio estimation, \cr
       \code{estim_1} - the estimated value for period1, \cr
       \code{estim_2} - the estimated value for period2, \cr
       \code{estim} - the estimated value, \cr
       \code{var} - the estimated variance, \cr
       \code{se} - the estimated standard error, \cr
       \code{CI_lower} - the estimated confidence interval lower bound, \cr
       \code{CI_upper} - the estimated confidence interval upper bound. \cr
       \code{significant} - is the the difference significant.
       }
}
\description{
Computes the variance estimation for measures of change for single and multistage stage cluster sampling designs.
}
\examples{

### Example 
library("data.table")
library("laeken")
data("eusilc")
set.seed(1)
eusilc1 <- eusilc[1:40,]
set.seed(1)
dataset1 <- data.table(rbind(eusilc1, eusilc1),
                       year = c(rep(2010, nrow(eusilc1)),
                                rep(2011, nrow(eusilc1))))
dataset1[age < 0, age := 0]
PSU <- dataset1[, .N, keyby = "db030"][, N := NULL]
PSU[, PSU := trunc(runif(nrow(PSU), 0, 5))]
dataset1 <- merge(dataset1, PSU, all = TRUE, by = "db030")
PSU <- eusilc <- NULL
dataset1[, strata := c("XXXX")]

dataset1[, t_pov := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, exp := 1]

# At-risk-of-poverty (AROP)
dataset1[, pov := ifelse (t_pov == 1, 1, 0)]
dataset1[, id_lev2 := paste0("V", .I)]


result <- vardchanges(Y = "pov", H = "strata", 
                      PSU = "PSU", w_final = "rb050",
                      ID_level1 = "db030", ID_level2 = "id_lev2",
                      Dom = NULL, Z = NULL, period = "year",
                      dataset = dataset1, period1 = 2010,
                      period2 = 2011, change_type = "absolute")
result

\dontrun{
data("eusilc")
dataset1 <- data.table(rbind(eusilc, eusilc),
                       year = c(rep(2010, nrow(eusilc)),
                                rep(2011, nrow(eusilc))))
dataset1[age < 0, age := 0]
PSU <- dataset1[,.N, keyby = "db030"][, N := NULL]
PSU[, PSU := trunc(runif(nrow(PSU), 0, 100))]
dataset1 <- merge(dataset1, PSU, all = TRUE, by = "db030")
PSU <- eusilc <- NULL
dataset1[, strata := "XXXX"]
  
dataset1[, t_pov := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_dep := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, t_lwi := trunc(runif(nrow(dataset1), 0, 2))]
dataset1[, exp := 1]
dataset1[, exp2 := 1 * (age < 60)]
  
# At-risk-of-poverty (AROP)
dataset1[, pov := ifelse (t_pov == 1, 1, 0)]
  
# Severe material deprivation (DEP)
dataset1[, dep := ifelse (t_dep == 1, 1, 0)]
  
# Low work intensity (LWI)
dataset1[, lwi := ifelse (t_lwi == 1 & exp2 == 1, 1, 0)]
  
# At-risk-of-poverty or social exclusion (AROPE)
dataset1[, arope := ifelse (pov == 1 | dep == 1 | lwi == 1, 1, 0)]
dataset1[, dom := 1]
dataset1[, id_lev2 := .I]
  
result <- vardchanges(Y = c("pov", "dep", "lwi", "arope"),
                      H = "strata", PSU = "PSU", w_final = "rb050",
                      ID_level1 = "db030", ID_level2 = "id_lev2",
                      Dom = "rb090", Z = NULL, period = "year",
                      dataset = dataset1, period1 = 2010, 
                      period2 = 2011, change_type = "absolute")
result}

}
\references{
Guillaume Osier,  Yves Berger,  Tim Goedeme, (2013), Standard error estimation for the EU-SILC indicators of poverty and social exclusion,  Eurostat Methodologies and Working papers, URL \url{http://ec.europa.eu/eurostat/documents/3888793/5855973/KS-RA-13-024-EN.PDF}. \cr
Eurostat Methodologies and Working papers, Handbook on precision requirements and variance estimation for ESS household surveys, 2013, URL \url{http://ec.europa.eu/eurostat/documents/3859598/5927001/KS-RA-13-029-EN.PDF}. \cr
Yves G. Berger, Tim Goedeme, Guillame Osier (2013). Handbook on standard error estimation and other related sampling issues in EU-SILC, URL \url{https://ec.europa.eu/eurostat/cros/content/handbook-standard-error-estimation-and-other-related-sampling-issues-ver-29072013_en} \cr
}
\seealso{
\code{\link{domain}},
         \code{\link{vardcros}},
         \code{\link{vardchangespoor}}
}
\keyword{vardchanges}
