% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{vmp_plot}
\alias{vmp_plot}
\title{Plot the posterior distributions of the focal parameters from a VM model}
\usage{
vmp_plot(alpha, useU = TRUE, plot = TRUE, digits = 3, ...)
}
\arguments{
\item{alpha}{Results from running \code{varian} and \code{extract}ing the
results.}

\item{useU}{Logical indicating whether to plot the latent intercepts
(defaults to \code{TRUE}).  Must set to \code{FALSE} if not available.}

\item{plot}{Logical whether to plot the results or just return the grob
for the plots.  Defaults to \code{TRUE}.}

\item{digits}{Integer indicating how many digits should be used
for displaying p-values}

\item{\dots}{Additional arguments (not currently used)}
}
\value{
A list containing the \code{Combined} and the \code{Individual} plot objects.
}
\description{
This function plots the univariate and bivariate (if applicable) distributions
of the focal (alpha) parameters from a Variability Model where the variability
is used as a predictor in a second-stage model.  The latent variability estimates are
referred to as \dQuote{Sigma} and, if used, the latent intercepts are referred
to as \dQuote{U}.
}
\examples{
# Using made up data because the real models take a long time to run
set.seed(1234) # make reproducible
vmp_plot(matrix(rnorm(1000), ncol = 2))
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{hplot}

