% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.alignment.sample.R
\name{run.alignment.sample}
\alias{run.alignment.sample}
\title{Run alignment for a single sample}
\usage{
run.alignment.sample(fastq.files, sample.id, output.directory = NULL,
  output.filename = NULL, code.directory = NULL,
  log.directory = NULL, config.file = NULL, job.dependencies = NULL,
  job.name = NULL, job.group = NULL, quiet = FALSE,
  verify.options = !quiet)
}
\arguments{
\item{fastq.files}{Paths to FASTQ files (one file if single-end reads, two files if paired-end)}

\item{sample.id}{Sample ID for labelling}

\item{output.directory}{Path to output directory}

\item{output.filename}{Name of resulting VCF file (defaults to SAMPLE_ID.vcf)}

\item{code.directory}{Path to directory where code should be stored}

\item{log.directory}{Path to directory where log files should be stored}

\item{config.file}{Path to config file}

\item{job.dependencies}{Vector with names of job dependencies}

\item{job.name}{Name of job to be submitted}

\item{job.group}{Group job should belong to}

\item{quiet}{Logical indicating whether to print command to screen rather than submit it to the system. Defaults to false, useful for debugging.}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\description{
Run alignment for a single sample
}
