% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.varitas.pipeline.hybrid.R
\name{run.varitas.pipeline.hybrid}
\alias{run.varitas.pipeline.hybrid}
\title{run.varitas.pipeline.hybrid}
\usage{
run.varitas.pipeline.hybrid(vcf.specification, output.directory,
  run.name = NULL, fastq.specification = NULL,
  bam.specification = NULL, variant.callers = c("mutect", "vardict",
  "varscan", "lofreq", "muse"), proton = FALSE, quiet = FALSE,
  email = NULL, verify.options = !quiet,
  save.specification.files = !quiet)
}
\arguments{
\item{vcf.specification}{Data frame containing details of vcf files to be processed. Must contain columns sample.id, vcf, and caller}

\item{output.directory}{Main directory where all files should be saved}

\item{run.name}{Name of pipeline run. Will be added as a prefix to all LSF jobs.}

\item{fastq.specification}{Data frame containing details of FASTQ files to be processed}

\item{bam.specification}{Data frame containing details of BAM files to be processed}

\item{variant.callers}{Vector specifying which variant callers should be run.}

\item{proton}{Logical indicating if data was generated by proton sequencing. Used to set base quality 
thresholds in variant calling steps.}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit jobs. Defaults to FALSE,
can be useful to set to TRUE for testing.}

\item{email}{Email address that should be notified when pipeline finishes. If NULL or FALSE, no email is sent.}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}

\item{save.specification.files}{Logical indicating if specification files should be saved to project directory}
}
\value{
None
}
\description{
Run VariTAS pipeline starting from both VCF files and BAM/ FASTQ files. 
Useful for processing data from the Ion PGM or MiniSeq where variant calling has been done on the machine, 
but you are interested in running more variant callers.
}
\examples{
run.varitas.pipeline.hybrid(
       bam.specification = data.frame(sample.id = c('Z', 'Y'), tumour.bam = c('Z.bam', 'Y.bam')),
       vcf.specification = data.frame(
         sample.id = c('a', 'b'),
         vcf = c('a.vcf', 'b.vcf'),
         caller = c('pgm', 'pgm')
       ),
       output.directory = '.',
       quiet = TRUE,
       run.name = "Test", 
       variant.callers = c('mutect', 'varscan')
     )

}
