% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{co2_emissions}
\alias{co2_emissions}
\title{CO2 emissions}
\format{
A data frame with 495 observations and 11 variables:
\itemize{
\item \code{country} : Country - Geographic location.
\item \code{year} : Year - Year of observation.
\item \code{co2} : Annual CO2 emissions - Annual total emissions of carbon dioxide (CO2), excluding land-use change, measured in million tonnes.
\item \code{co2_per_gdp} : Annual CO2 emissions per GDP (kg per international-$) - Annual total emissions of carbon dioxide (CO2), excluding land-use change, measured in kilograms per dollar of GDP (2011 international-$).
\item \code{co2_per_capita} : Annual CO2 emissions (per capita) - Annual total emissions of carbon dioxide (CO2), excluding land-use change, measured in tonnes per person.
\item \code{co2_growth_abs} : Annual CO2 emissions growth (abs) - Annual growth in total emissions of carbon dioxide (CO2), excluding land-use change, measured in million tonnes.
\item \code{co2_growth_prct} : Annual CO2 emissions growth (\%) - Annual percentage growth in total emissions of carbon dioxide (CO2), excluding land-use change.
\item \code{co2_per_unit_energy} : Annual CO2 emissions per unit energy (kg per kilowatt-hour) - Annual total emissions of carbon dioxide (CO2), excluding land-use change, measured in kilograms per kilowatt-hour of primary energy consumption.
\item \code{consumption_co2} : Annual consumption-based CO2 emissions - Annual consumption-based emissions of carbon dioxide (CO2), measured in million tonnes.
\item \code{consumption_co2_per_capita} : Per capita consumption-based CO2 emissions - Annual consumption-based emissions of carbon dioxide (CO2), measured in tonnes per person.
\item \code{consumption_co2_per_gdp} : Annual consumption-based CO2 emissions per GDP (kg per international-$) - Annual consumption-based emissions of carbon dioxide (CO2), measured in kilograms per dollar of GDP (2011 international-$).
}
}
\source{
\href{https://github.com/owid/co2-data}{Our World In Data}
}
\usage{
co2_emissions
}
\description{
This dataset represents CO2 emissions for a subset of country over the period 1990 - 2022.
}
\note{
Documentation is from Our World In Data, see \url{https://github.com/owid/co2-data} for the data
and \url{https://ourworldindata.org/co2-and-greenhouse-gas-emissions} for more about CO2 emissions.
}
\keyword{datasets}
