% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_sankey}
\alias{v_sankey}
\title{Create a Sankey Chart}
\usage{
v_sankey(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Sankey Chart
}
\examples{

library(vchartr)

# Basic Sankey Chart
vchart(energy_sankey) \%>\%
  v_sankey(aes(target, source, value = value))

# Some options
vchart(energy_sankey) \%>\%
  v_sankey(
    aes(target, source, value = value),
    nodeAlign = "left",
    nodeGap = 8,
    nodeWidth = 10,
    minNodeHeight = 4,
    link = list(
      state = list(
        hover = list(
          fillOpacity = 1
        )
      )
    )
  )


# With data as tree structure
titanic <- as.data.frame(Titanic)
vchart(titanic) \%>\%
  v_sankey(aes(
    lvl1 = Class,
    lvl2 = Sex,
    lvl3 = Age,
    lvl4 = Survived,
    value = Freq
  ))


# Only one level
titanic_class <- titanic \%>\%
  aggregate(data = ., Freq ~ Class + Survived, FUN = sum)

vchart(titanic_class) \%>\%
  v_sankey(aes(Survived, Class, value = Freq))



}
