% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_legend}
\alias{v_specs_legend}
\title{Set legend options}
\usage{
v_specs_legend(vc, ..., add = FALSE)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{Options for the legend, see examples or
\href{https://www.visactor.io/vchart/guide/tutorial_docs/Chart_Concepts/Legend}{online documentation}.}

\item{add}{Add the legend to exiting ones or overwrite all previous legends.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Set legend options
}
\examples{
library(vchartr)
data("mpg", package = "ggplot2")

vchart(table(Class = mpg$class, Year = mpg$year)) \%>\%
  v_bar(aes(Class, Freq, fill = Year)) \%>\%
  v_specs_legend(
    title = list(text = "Title", visible = TRUE),
    orient = "right",
    position = "start",
    item = list(focus = TRUE)
  )
}
