% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInvasiveSums.R
\name{plotInvasiveSums}
\alias{plotInvasiveSums}
\title{Plot cumulative sum and interval sums of invasive species}
\usage{
plotInvasiveSums(
  token,
  interval,
  target_year,
  invasive_species,
  agency_ids = NULL
)
}
\arguments{
\item{token}{A valid access token returned from `getToken()`}

\item{interval}{Calculation interval for abundance, accepts "CollectionDate",“Week”, “Biweek”, or “Month.}

\item{target_year}{Year to plot}

\item{invasive_species}{Names of invasive species to be plotted, multiple invasive species are entered in vector format i.e. `invasive_species = c("Ae aegypti", "Ae albopictus")`}

\item{agency_ids}{An optional vector for filtering agency by id}
}
\description{
This function graphs the cumulative sum of invasive mosquito specie(s) as a line chart over a selected interval.The bar chart shows the interval sum of invasive specie(s).
For cumulative sum, a convex slope indicates increased rate of species trappings, concave a decrease in rate, and liner a constant rate.
}
