% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.r
\name{add_filter}
\alias{add_filter}
\title{Add a filter}
\usage{
add_filter(vl, expr)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{expr}{Vega Expression for filtering data items (or rows). Each datum
object can be referred using bound variable datum. For example, setting
\code{expr} to \code{"datum.datum.b2 > 60"} would make the output data includes only
items that have values in the field \code{b2} over 60.}
}
\description{
Add a filter
}
\examples{
vegalite(viewport_height=200, viewport_width=200) \%>\%
  cell_size(200, 200) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/population.json") \%>\%
  add_filter("datum.year == 2000") \%>\%
  calculate("gender", 'datum.sex == 2 ? "Female" : "Male"') \%>\%
  encode_x("gender", "nominal") \%>\%
  encode_y("people", "quantitative", aggregate="sum") \%>\%
  encode_color("gender", "nominal") \%>\%
  scale_x_ordinal(band_size=6) \%>\%
  scale_color_nominal(range=c("#EA98D2", "#659CCA")) \%>\%
  facet_col("age", "ordinal", padding=4) \%>\%
  axis_x(remove=TRUE) \%>\%
  axis_y(title="population", grid=FALSE) \%>\%
  axis_facet_col(orient="bottom", axisWidth=1, offset=-8) \%>\%
  facet_cell(stroke_width=0) \%>\%
  mark_bar()
}

