% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv.site.R
\name{tv.site}
\alias{tv.site}
\title{Load site data from Turboveg Database}
\usage{
tv.site(db, tv_home, drop=TRUE, common.only = FALSE, verbose = TRUE, replace.names, ...)
}
\arguments{
\item{db}{(character) Name of your Turboveg database(s). Directory name containing tvabund.dbf, tvhabita.dbf and tvwin.set.}

\item{tv_home}{(character) Turbowin installation path. Optional, if Turbowin is either on "C:/Turbowin" or "C:/Programme/Turbowin".}

\item{drop}{(logical) Drop variables without values.}

\item{common.only}{(logical) Import only header data with the same name in all databases.}

\item{verbose}{(logical) print warnings and hints}

\item{replace.names}{(data.frame) replace variable names. Useful if using multiple source databases. Data frame with names to be replaced in first and replacing names in second column.}

\item{\dots}{Additional options like \code{dec} for type.convert}
}
\value{
data.frame of site variables.
}
\description{
Loading Turboveg header data and do basic data evaluation. Empty columns are eliminated and warnings about possibly wrong '0' values are performed
}
\details{
Please specify pathnames below but not above Turbowin/Data. Can be a single database or a character vector of multiple databases. In the latter case you have to assure, that all databases use the same taxonomic reference list.

  You can use the example in the final output line to make a summary statistic for attributes with potentially misleading '0' values. Just delete the \" at beginning and end.
}
\author{
Florian Jansen \email{florian.jansen@uni-rostock.de}
}
\keyword{#'#'}
\keyword{Area}
\keyword{Survey}
\keyword{Turboveg}
