% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-box.R, R/service-channel9.R,
%   R/service-msstream.R, R/service-vimeo.R, R/service-youtube.R,
%   R/use_start_time.R
\name{use_start_time.vembedr_embed_box}
\alias{use_start_time.vembedr_embed_box}
\alias{use_start_time.vembedr_embed_channel9}
\alias{use_start_time.vembedr_embed_msstream}
\alias{use_start_time.vembedr_embed_vimeo}
\alias{use_start_time.vembedr_embed_youtube}
\alias{use_start_time}
\alias{use_start_time.default}
\title{Specify start time}
\usage{
\method{use_start_time}{vembedr_embed_box}(embed, ...)

\method{use_start_time}{vembedr_embed_channel9}(embed, start_time, is_paused = TRUE, ...)

\method{use_start_time}{vembedr_embed_msstream}(embed, start_time, ...)

\method{use_start_time}{vembedr_embed_vimeo}(embed, start_time, ...)

\method{use_start_time}{vembedr_embed_youtube}(embed, start_time, ...)

use_start_time(embed, ...)

\method{use_start_time}{default}(embed, ...)
}
\arguments{
\item{embed}{\code{vembedr_embed} object, created using an \code{\link[=embed]{embed()}} function}

\item{...}{generic arguments to pass through}

\item{start_time}{\code{numeric} (seconds), or \code{character} (e.g. \code{"3m15s"})}

\item{is_paused}{\code{logical}, for "Channel 9" specifies if the video
should be paused at this time}
}
\value{
Object with S3 class \code{vembedr_embed}.
}
\description{
This function provides you a consistent way to specify the start time,
regardless of the service. Please note that Box does not provide a
means to specify the start time.
}
\details{
The \code{start_time} argument can take a variety of formats; these inputs
all evaluate to the same value:

\itemize{
\item{\code{"0h1m0s"}, \code{"0h01m00s"}, \code{"0h1m"}}
\item{\code{"1m0s"}, \code{"1m"}}
\item{\code{"60s"}, \code{60}}
}

Please note that for Vimeo, you can specify a start time, but you can not
specify that the video be paused at this time. In other words, it is like
"autoplay" is set to \code{TRUE}, and you cannot unset it.
}
\examples{
  rickroll_youtube() \%>\%
    use_start_time("3m32s")

}
