% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluralise.R
\name{pluralise}
\alias{pluralise}
\title{Pluralise words if their accompanying number is not 1}
\usage{
pluralise(
  word,
  count,
  plural = "s",
  add_or_swap = "add",
  include_number = TRUE,
  sentence_start = FALSE,
  zero_or_no = "no",
  uk_or_us = "UK",
  big_mark = ","
)
}
\arguments{
\item{word}{A word which should be returned as plural if \code{count} is not equal to 1.}

\item{count}{A number to apply to \code{word}}

\item{plural}{How to make the plural; defaults to an "s" which is added at the end of the word.
Can be anything. See \code{add_or_swap}.}

\item{add_or_swap}{Choose between \code{add} (add the plural form (e.g. "s") onto the end; e.g. \code{house}
becomes \code{houses}) and \code{swap} (swap for the plural form; e.g. \code{mouse} becomes \code{mice})}

\item{include_number}{Logical. If \code{TRUE}, the number will be turned into text, as per \code{num_to_text()} (if it is a whole number, )}

\item{sentence_start}{Logical. Defaults to \code{FALSE}, which results in only numbers 1-10 being written out in full.
If \code{TRUE}, numbers 11-999 are written out in full if included. (If \code{include_number} is \code{FALSE}, the first letter of \code{word} is capitalised.)}

\item{zero_or_no}{Prefered string to use where count == 0. Defaults to "no". Can be anything.}

\item{uk_or_us}{Only used if \code{include_number} == \code{TRUE}. Defaults to UK which adds an "and" between "hundred" and other numbers
(e.g. "One hundred and five"). If "US" is chosen, the "and" is removed (e.g. "One hundred five").}

\item{big_mark}{Passed to \code{num_to_text}. Defaults to "," (e.g. "1,999")}
}
\value{
A word which is pluralised or not based on the value of \code{count}
}
\description{
Pluralise words if their accompanying number is not 1
}
\examples{
pluralise("penguin", 3)
pluralise("bateau", 1234, "x")
pluralise("sheep", 333, "sheep", add_or_swap = TRUE, sentence_start =  TRUE)

}
