\name{pdpropper}
\alias{pdpropper}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Power Divergence Test for Equal of Given Proportions
}
\description{
Used for testing the null that proportions (probabilities of success) in
several groups are the same, or that they equal certain given values.
}
\usage{
pdpropper(x, n, p = NULL, lambda = c(-2, -1, -1/2, 0, 2/3, 1),
    alternative = c("two.sided", "less", "greater"),
    alpha = 0.05, correct = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
  a vector of counts of successes, a one-dimensional table with two entries, or
  a two-dimensional table (or matrix) with two columns, giving hte counts of
  successes and failures, resp.
}
  \item{n}{
  a vector of counts of trials, which is ignored if x is a matrix or a table.
}
  \item{p}{
  a vector of probabilities of success.  Must have same length as the number
  of groups specified by x, and its elements must be in (0,1).
}
  \item{lambda}{
  vector of lambda values.
}
  \item{alternative}{
  a character string specifying the alternative hypothesis.
}
  \item{alpha}{
  single numeric giving the size of the test
}
  \item{correct}{
  logical stating whether or not to apply the moment correction or not.
}
}
\details{

See the help file for powerdiverger for more information on the power-divergence
statistic.  This function is specific to testing equal or given proportions.  The
former does not allow this type of testing, though they are very similar tests.

See the help file for prop.test for more information about the type of test.  For
lambda = 1, the two tests should give the same results.
}
\value{
Returns an object of either class htest or, if lambda is a vector with length
greater than 1, a list of htest components.  See powerdiverger for more information.
}
\references{
Cressie, N., and T. R. C. Read (1984).  Multinomial goodness-of-fit tests.
\emph{J. Roy. Stat. Soc.}, \bold{46}, 440--464.

Freeman, M. F., and J. W. Tukey (1950). Transformations related to the angular and
the square root. \emph{Ann. Math. Stat.}, \bold{21}, 607--611,
doi: 10.1214/aoms/1177729756.

Gilleland, E., D. Munoz-Esparza, and D. D. Turner (2023). Competing forecast verification:
Using the power-divergence statistic for testing the frequency of better.

Kullback, S., and R. A. Leibler (1951). On information and sufficiency.
\emph{Ann. Math. Stat.}, \bold{22}, 79--86, doi: 10.1214/aoms/1177729694.

Neyman, J. (1949). Contribution to the theory of the x2 test.
\emph{Proc. First Berkeley Symp. on Mathematical Statistics and Probability},
Berkeley, CA, University of California, 239--273.

Pearson, K. (1900). On the criterion that a given system of deviations from the
probable in the case of a correlated system of variables is such that it can
be reasonably supposed to have arisen from random sampling. \emph{Philos. Mag.},
\bold{50}, 157--175, doi: 10.1080/14786440009463897.

Read, T. R. C., and N. A. C. Cressie (1988). \emph{Goodness-of-Fit Statistics
for Discrete Multivariate Data}. 1st ed. Springer-Verlag, New York, 212 pp.

}
\author{
Eric Gilleland
}

\seealso{
\code{\link{prop.test}}, \code{\link{powerdiverger}}
}
\examples{

# These examples are the same as those in prop.test.
heads <- rbinom(1, size = 100, prob = .5)
prop.test(heads, 100, correct = FALSE)
pdpropper( heads, 100 )

## Data from Fleiss (1981), p. 139.
## H0: The null hypothesis is that the four populations from which
##     the patients were drawn have the same true proportion of smokers.
## A:  The alternative is that this proportion is different in at
##     least one of the populations.

smokers  <- c( 83, 90, 129, 70 )
patients <- c( 86, 93, 136, 82 )
prop.test(smokers, patients)
pdpropper( smokers, patients )
}
% \keyword{ htest }
