% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progression_sources.r
\name{progression.plr.nouri.2012}
\alias{progression.plr.nouri.2012}
\title{Nouri-Mahdavi 2012 VF progression}
\usage{
progression.plr.nouri.2012(measmatrix)
}
\arguments{
\item{measmatrix}{is a data frame. MUST contain the following columns: 52/54 TD (column names MUST be 'td1' ~ 'td52' or 'td1' ~ 'td54'), 'yearsfollowed', and 'eyeid'. Rows represent the single measurements. The minimum measurements (rows) is 3.}
}
\value{
"stable", "worsening", or "improving" of measurements in \code{measmatrix}
}
\description{
\code{progression.plr.nouri.2012} returns the progression criterion, using  Pointwise Linear Regression (PLR) progression detection method according to Nouri-Mahdavi et al. (2012).
}
\examples{
data(vf.plr.nouri.2012)
colnames(vf.plr.nouri.2012)
progression.plr.nouri.2012(vf.plr.nouri.2012)
progression.plr.nouri.2012(vf.plr.nouri.2012[vf.plr.nouri.2012$eyeid == 1,])
progression.plr.nouri.2012(vf.plr.nouri.2012[vf.plr.nouri.2012$eyeid == 2,])
}
\seealso{
\url{https://www.ncbi.nlm.nih.gov/pubmed/22427560/}
}
