% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_map.R
\name{draw_map_shiny}
\alias{draw_map_shiny}
\title{Draws linkage map, parents haplotypes and marker doses
Adapted from MAPpoly}
\usage{
draw_map_shiny(
  left.lim = 0,
  right.lim = 5,
  ch = 1,
  maps.dist,
  ph.p1,
  ph.p2,
  d.p1,
  d.p2,
  snp.names = TRUE,
  software = NULL
)
}
\arguments{
\item{left.lim}{covered window in the linkage map start position}

\item{right.lim}{covered window in the linkage map end position}

\item{ch}{linkage group ID}

\item{ph.p1}{list containing a data.frame for each group with parent 1 estimated phases. The data.frame contain the columns:
1) Character vector with chromosome ID; 2) Character vector with marker ID;
3 to (ploidy number)*2 columns with each parents haplotypes}

\item{ph.p2}{list containing a data.frame for each group with parent 2 estimated phases. See ph.p1 parameter description.}

\item{d.p1}{list containing a data.frame for each group with parent 1 dosages. The data.frame contain the columns: 
1) character vector with chromosomes ID; 
2) Character vector with markers ID; 3) Character vector with parent ID; 
4) numerical vector with dosage}

\item{d.p2}{list containing a data.frame for each group with parent 2 dosages. See d.p1 parameter description}

\item{snp.names}{logical TRUE/FALSE. If TRUE it includes the marker names in the plot}

\item{software}{character defined from each software it comes from}

\item{maps}{list containing a vector for each linkage group markers with marker positions (named with marker names)}
}
\value{
graphic representing selected section of a linkage group
}
\description{
Draws linkage map, parents haplotypes and marker doses
Adapted from MAPpoly
}
\keyword{internal}
