% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/village.R
\docType{class}
\name{village}
\alias{village}
\title{Village}
\description{
This is an object that represents the state of a village at a particular time.
}
\details{
This class acts as a type of record that holds the values of the
different village variables. This class can be subclassed to include more variables that aren't present.
}
\section{Methods}{

\describe{
\item{\code{initialize()}}{Creates a new village}
\item{\code{propagate()}}{Advances the village a single time step}
\item{\code{set_initial_state()}}{Initializes the initial state of the village}
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{An optional name for the village}

\item{\code{initial_condition}}{A function that sets the initial state of the village}

\item{\code{current_state}}{The village's current state}

\item{\code{previous_state}}{The village's previous state}

\item{\code{models}}{A list of functions or a single function that should be run at each timestep}

\item{\code{model_data}}{Optional data that models may need}

\item{\code{agent_mgr}}{The manager that handles all of the agents}

\item{\code{resource_mgr}}{The manager that handles all of the resources
Initializes a village}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-village-new}{\code{village$new()}}
\item \href{#method-village-propagate}{\code{village$propagate()}}
\item \href{#method-village-set_initial_state}{\code{village$set_initial_state()}}
\item \href{#method-village-clone}{\code{village$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village-new"></a>}}
\if{latex}{\out{\hypertarget{method-village-new}{}}}
\subsection{Method \code{new()}}{
This method is meant to set the variables that are needed for a village to propagate through
time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village$new(
  name,
  initial_condition,
  models = list(),
  agent_class = villager::agent,
  resource_class = villager::resource
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{An optional name for the village}

\item{\code{initial_condition}}{A function that gets called on the first time step}

\item{\code{models}}{A list of functions or a single function that should be run at each time step}

\item{\code{agent_class}}{The class that's being used to represent agents}

\item{\code{resource_class}}{The class being used to describe the resources
Propagates the village a single time step}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village-propagate"></a>}}
\if{latex}{\out{\hypertarget{method-village-propagate}{}}}
\subsection{Method \code{propagate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village$propagate(current_step)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current_step}}{The current time step}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is used to advance the village a single time step. It should NOT be used
to set initial conditions. See the set_initial_state method.
}

\subsection{Returns}{
None
Runs the user defined function that sets the initial state of the village
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village-set_initial_state"></a>}}
\if{latex}{\out{\hypertarget{method-village-set_initial_state}{}}}
\subsection{Method \code{set_initial_state()}}{
Runs the initial condition model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village$set_initial_state()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-village-clone"></a>}}
\if{latex}{\out{\hypertarget{method-village-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{village$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
