% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital.R
\name{as_vital}
\alias{as_vital}
\alias{as_vital.demogdata}
\alias{as_vital.tbl_ts}
\alias{as_vital.data.frame}
\title{Coerce to a vital object}
\usage{
as_vital(x, ...)

\method{as_vital}{demogdata}(x, sex_groups = TRUE, ...)

\method{as_vital}{tbl_ts}(
  x,
  .age = NULL,
  .sex = NULL,
  .deaths = NULL,
  .births = NULL,
  .population = NULL,
  reorder = FALSE,
  ...
)

\method{as_vital}{data.frame}(
  x,
  key = NULL,
  index,
  .age = NULL,
  .sex = NULL,
  .deaths = NULL,
  .births = NULL,
  .population = NULL,
  reorder = TRUE,
  ...
)
}
\arguments{
\item{x}{Object to be coerced to a vital format.}

\item{...}{Other arguments passed to \code{\link[tsibble:as-tsibble]{tsibble::as_tsibble()}}}

\item{sex_groups}{Logical variable indicating if the groups denote sexes}

\item{.age}{Character string with name of age variable}

\item{.sex}{Character string with name of sex variable}

\item{.deaths}{Character string with name of deaths variable}

\item{.births}{Character string with name of births variable}

\item{.population}{Character string with name of population variable}

\item{reorder}{Logical indicating if the variables should be reordered.}

\item{key}{Variable(s) that uniquely determine time indices. NULL for empty key,
and \code{\link[=c]{c()}} for multiple variables. It works with tidy selector
(e.g. \code{\link[tidyselect:starts_with]{tidyselect::starts_with()}}).}

\item{index}{A variable to specify the time index variable.}
}
\value{
A tsibble with class \code{vital}.
}
\description{
A vital object is a type of tsibble that contains vital statistics such as
births, deaths, and population counts, and mortality and fertility rates.
It is a tsibble with a special class that allows for special methods to be used.
The object has an attribute that stores variables names needed for some
functions, including age, sex, births, deaths and population.
}
\examples{
\dontshow{if (requireNamespace("demography", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# coerce demogdata object to vital
as_vital(demography::fr.mort)
\dontshow{\}) # examplesIf}
# create a vital with only age as a key
data.frame(
  year = rep(2010:2015, 100),
  age = rep(0:99, each = 6),
  mx = runif(600, 0, 1)
) |>
  as_vital(
    index = year,
    key = age,
    .age = "age"
  )
}
\seealso{
\code{\link[tsibble:tsibble]{tsibble::tsibble()}}
}
\author{
Rob J Hyndman
}
