% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rogers.R
\name{create_rogers}
\alias{create_rogers}
\title{Generate Rogers Adoption Curve plots for Copilot usage}
\usage{
create_rogers(
  data,
  hrvar = NULL,
  metric,
  width = 9,
  max_window = 12,
  threshold = 1,
  start_metric,
  return = "plot",
  plot_mode = 1
)
}
\arguments{
\item{data}{Data frame containing Person Query data to be analyzed. Must
contain \code{PersonId}, \code{MetricDate}, and the specified metrics.}

\item{hrvar}{Character string specifying the HR attribute or organizational
variable to group by. Default is \code{NULL}, for no grouping.}

\item{metric}{Character string containing the name of the metric to analyze
for habit identification, e.g. "Total_Copilot_actions". This is passed to
\code{identify_habit()}.}

\item{width}{Integer specifying the number of qualifying counts to consider
for a habit. Passed to \code{identify_habit()}. Default is 9.}

\item{max_window}{Integer specifying the maximum unit of dates to consider a
qualifying window for a habit. Passed to \code{identify_habit()}. Default is 12.}

\item{threshold}{Numeric value specifying the minimum threshold for the
metric to be considered a qualifying count. Passed to \code{identify_habit()}.
Default is 1.}

\item{start_metric}{Character string containing the name of the metric used
for determining enablement start date. This metric should track when users
first gained access to the technology being analyzed. The function identifies
the earliest date where this metric is greater than 0 for each user as their
"enablement date". This is then used in plot modes 3 and 4 to calculate
time-to-adoption and Rogers segment classifications. The suggested variable
is "Total_Copilot_enabled_days", but any metric that indicates access or
licensing status can be used (e.g., "License_assigned_days", "Access_granted").}

\item{return}{Character vector specifying what to return. Valid inputs are
"plot", "data", and "table". Default is "plot".}

\item{plot_mode}{Integer or character string determining which plot to return.
Valid inputs are:
\itemize{
\item 1 or "cumulative": Rogers Adoption Curve showing cumulative adoption
\item 2 or "weekly": Weekly Rate of adoption showing new habitual users
\item 3 or "enablement": Enablement-based adoption rate with Rogers segments
\item 4 or "cumulative_enablement": Cumulative adoption adjusted for enablement
}
Default is 1.}
}
\value{
Returns a 'ggplot' object by default when 'plot' is passed in \code{return}.
When 'table' is passed, a summary table is returned as a data frame.
When 'data' is passed, the processed data with habit classifications is returned.
}
\description{
Creates various visualizations based on the Rogers adoption curve theory,
analyzing the adoption patterns of Copilot usage. The function identifies
habitual users using the \code{identify_habit()} function and then creates
adoption curve visualizations based on different time frames and
organizational groupings.
}
\details{
This function provides four distinct plot modes to analyze adoption patterns:

\strong{Plot Mode 1 - Cumulative Adoption Curve:}
Shows the classic Rogers adoption curve with cumulative percentage of habitual
users over time. This S-shaped curve helps identify the pace of adoption and
when saturation begins. Steep sections indicate rapid adoption periods, while
flat sections suggest slower uptake or natural limits.

\strong{Plot Mode 2 - Weekly Adoption Rate:}
Displays the number of new habitual users identified each week, with a
3-week moving average line to smooth volatility. This view helps identify
adoption spikes, seasonal patterns, and the natural ebb and flow of user
onboarding. High bars indicate successful onboarding periods.

\strong{Plot Mode 3 - Enablement-Based Adoption:}
Analyzes adoption relative to when users were first enabled (had access).
Users are classified into Rogers segments (Innovators, Early Adopters,
Early/Late Majority, Laggards) based on how quickly they adopted after
enablement. This helps understand the natural distribution of adoption
speed within your organization.

\strong{Plot Mode 4 - Cumulative Enablement-Adjusted:}
Similar to Mode 1 but only includes users who had enablement data, providing
a more accurate view of adoption among those who actually had access to the
technology. This removes noise from users who may not have been properly
enabled.

\strong{Interpretation Guidelines:}
\itemize{
\item Early steep curves suggest strong product-market fit
\item Plateaus may indicate training needs or feature limitations
\item Seasonal patterns often reflect organizational training cycles
\item Rogers segments help identify user personas for targeted interventions
}
}
\examples{
# Basic Rogers adoption curve
create_rogers(
  data = pq_data,
  metric = "Copilot_actions_taken_in_Teams",
  plot_mode = 1
)

# Weekly adoption rate by organization
create_rogers(
  data = pq_data,
  hrvar = "Organization",
  metric = "Copilot_actions_taken_in_Teams",
  plot_mode = 2
)

# Enablement-based adoption
create_rogers(
  data = pq_data,
  metric = "Copilot_actions_taken_in_Teams",
  start_metric = "Total_Copilot_enabled_days",
  plot_mode = 3
)

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar}()},
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_dist}()},
\code{\link{external_fizz}()},
\code{\link{external_line}()},
\code{\link{external_rank}()},
\code{\link{external_sum}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()}
}
\author{
Chris Gideon \href{mailto:chris.gideon@microsoft.com}{chris.gideon@microsoft.com}
}
\concept{Adoption Analysis}
\concept{Visualization}
