% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missDimPerId.R
\name{MissDimPerId}
\alias{MissDimPerId}
\title{What IDs have missing dimensions?}
\usage{
MissDimPerId(
  path = ".",
  audioList = NULL,
  ids = c(),
  fileType = "wav",
  fileNamePattern = "ID_Condition_Dimension",
  sep = "_",
  recursive = FALSE
)
}
\arguments{
\item{path}{Character string indicating the path to the folder containing the audio files. Default corresponds to the current working directory.}

\item{audioList}{Optional list with Wave objects to analyze.}

\item{ids}{Character vector indicating the IDs of the files.}

\item{fileType}{Character string indicating the file format (wav or mp3) of the audio files. Default corresponds to wav.}

\item{fileNamePattern}{Character string indicating the naming format of the audio files, such as "ID-Condition-Dimension", "Condition_ID_Dimension" or "ID". Default corresponds to "ID_Condition_Dimension".}

\item{sep}{A non alpha-numeric that acts as separator between the different naming components. Default corresponds to underscore.}

\item{recursive}{A logical value indicating whether subdirectories should be included when searching for voice files. Default corresponds to FALSE.}
}
\value{
A data.frame, in which rows represent IDs and columns represent missing vs. present Dimensions.
}
\description{
Indicates whether and which dimensions are missing for each ID.
}
\examples{
MissDimPerId(audioList = testAudioList)
}
