% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableDunn.R
\name{tableDunn}
\alias{tableDunn}
\title{Create a Table for the results of a Dunn's test}
\usage{
tableDunn(
  audioData,
  by = c(),
  measure = "duration",
  nameMeasure = c(),
  figureNumber = 1
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{by}{A character vector indicating the name of the factor(s).}

\item{measure}{Name of the dependent variable.}

\item{nameMeasure}{Optional string to rename dependent variable in the output table. If no value is provided, then original variable name is displayed.}

\item{figureNumber}{Integer indicating the figure number, used to create the title for the table. Default corresponds to 1.}
}
\value{
HTML table showing Dunn's test results in APA formatting style.
}
\description{
Automatically generates HTML table with results for Dunn's test.
}
\examples{
tableDunn(testAudioData, by = "Condition", measure = "duration")

}
