% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableKruskal.R
\name{tableKruskal}
\alias{tableKruskal}
\title{Create a table for Kruskal-Wallis test results}
\usage{
tableKruskal(
  audioData,
  by = c(),
  measure = "duration",
  nameMeasure = c(),
  figureNumber = 1,
  InfoTable = FALSE
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{by}{A character vector indicating the name of the factor(s).}

\item{measure}{Name of the dependent variable.}

\item{nameMeasure}{Optional string to rename dependent variable in the output table. If no value is provided, original variable name is displayed.}

\item{figureNumber}{Integer indicating the figure number, used to create the title for the table. Default corresponds to 1.}

\item{InfoTable}{Logical value indicating the type of table to be reported. If FALSE, a table containing the mean ranks for each group is displayed; if TRUE, a table containing the main results for the Kruskal-Wallis test is displayed. Default corresponds to FALSE.}
}
\value{
HTML table showing Kruskal-Wallis test results in APA formatting style.
}
\description{
Automatically generates HTML table with the results of a Kruskal-Wallis test.
}
\examples{
tableKruskal(testAudioData, by = "Condition", measure = "duration")

}
