% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piano_plot.R
\name{piano_plot}
\alias{piano_plot}
\title{Piano plot}
\usage{
piano_plot(data, num_fmt = 0)
}
\arguments{
\item{data}{Data frame or tibble containing the desired frequencies to be plotted.}

\item{num_fmt}{Number of the desired formant (includes f0 for simplicity). Default: \code{num_fmt = 0}.}
}
\description{
Piano plot showing the notes in Scientific Pitch Notation.
}
\examples{
library(voice)
# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern = glob2rx('*.wav'), full.names = TRUE)
# Media dataset
M <- extract_features(path2wav)
piano_plot(M, 0)
piano_plot(M, 0:2)
}
\references{
https://en.wikipedia.org/wiki/12_equal_temperament

https://en.wikipedia.org/wiki/Scientific_pitch_notation
}
