% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_aStraddlePnL.R
\name{aStraddlePnL}
\alias{aStraddlePnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Straddle Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
aStraddlePnL(
  ST,
  X,
  C,
  P,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium or Call Price paid for the bought Call.}

\item{P}{Put Premium or Put Price paid for the bought put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
According to Kakushadze and Serur (2018), non directional strategies can be divided into two subgroups: (a) volatility strategies that profit if the stock has large price movements (high volatility environment); and (b) sideways strategies that profit if the stock price remains stable (low volatility environment). Here, in this package only high volatility option strategies are discussed and represented through their graphs.\cr
This is a volatility strategy consisting of a long position in an ATM (at the money) call option, and a long position in an ATM (at the money) put option with a strike price X. This is a net debit trade. The trader or investor has a neutral outlook. This is a capital gain strategy (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Straddle Option Strategy and draw its graph in the Plots tab.
}
\examples{
aStraddlePnL(25,25,2.40,1.70)
aStraddlePnL(40,40,3,2,hl=0.7,hu=1.2)
aStraddlePnL(1000,1010,18,10,hl=0.955,hu=1.055)
}
