% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_longCallSyntheticStraddlePnL.R
\name{longCallSyntheticStraddlePnL}
\alias{longCallSyntheticStraddlePnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Call Synthetic Straddle Option Strategy and draws its Bar Plot displaying PnL in the plots tab.}
\usage{
longCallSyntheticStraddlePnL(
  ST,
  X,
  C1,
  C2,
  S0,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C1}{Call Premium or Call Price paid for the first bought Call.}

\item{C2}{Call Premium or Call Price paid for the second bought Call.}

\item{S0}{Stock Price at which the stock is shorted.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This volatility strategy (which is the same as a long straddle with the put replaced by a synthetic put) amounts to shorting stock and buying two ATM (or the nearest ITM call options with a strike price X. The trader’s outlook is neutral. This is a capital gain strategy (assuming S0 is greater than or equal to X and V0 is greater than (S0 minus X)) (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long Call Synthetic Straddle Option Strategy and draw its graph in the plots tab.
}
\examples{
longCallSyntheticStraddlePnL(25,25,2,2,25.10)
longCallSyntheticStraddlePnL(40,40,7,7,41,hl=0.4,hu=1.7)
}
