% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_coords_2x3.R
\name{calc_stats_2x3}
\alias{calc_stats_2x3}
\title{Calculate p-values for 2x3-way analysis}
\usage{
calc_stats_2x3(
  data,
  outcome,
  group,
  padj.method,
  test = c("t.test", "wilcoxon"),
  exact = FALSE
)
}
\arguments{
\item{data}{Dataframe or matrix with variables in columns and samples in rows}

\item{outcome}{Factor with 2 levels}

\item{group}{Factor with 3 levels}

\item{padj.method}{Can be \code{"qvalue"} or any method available in \code{p.adjust}.
The option \code{"none"} is a pass-through.}

\item{test}{Character value specifying the statistical test between the 2
level response outcome. Current options are "t.test" or "wilcoxon".}

\item{exact}{Logical for whether to use an exact test (Wilcoxon test only)}
}
\value{
A list containing a data frame with summary statistics for the
comparisons between the outcome, for each group level.
}
\description{
Calculate p-values for 2x3-way analysis
}
