% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{data_round}
\alias{data_round}
\title{Round and format selected numeric columns}
\usage{
data_round(data, cols, digits)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{cols}{A tidyselect expression specifying which columns to round
(e.g., \code{c(var1, var2)} or \code{starts_with("score")}).}

\item{digits}{Integer; number of decimal places to round.}
}
\value{
The input data frame, with the specified numeric columns rounded
and formatted as character vectors.
}
\description{
Round and format specified numeric columns in a data frame
to a fixed number of decimal places.
}
\details{
For each selected numeric column:
\itemize{
\item The column is rounded using \code{round()}.
\item It is then formatted as a character vector with a fixed number of
decimal places using \code{sprintf()}.
\item Missing values (\code{NA}) are preserved as \code{NA_character_}.
\item Original non-essential attributes (except \code{class} and
\code{levels}) are restored.
}
}
\keyword{internal}
