% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.web.R, R/zzz.R
\name{Collect.web}
\alias{Collect.web}
\alias{collect_web_hyperlinks}
\title{Collect hyperlinks from web pages}
\usage{
\method{Collect}{web}(credential, pages = NULL, ..., writeToFile = FALSE, verbose = TRUE)

collect_web_hyperlinks(pages = NULL, writeToFile = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"web"}.}

\item{pages}{Dataframe. Dataframe of web pages to crawl. The dataframe must have the columns \code{page} (character),
\code{type} (character) and \code{max_depth} (integer). Each row is a seed web page to crawl, with the \code{page}
value being the page URL. The \code{type} value is type of crawl as either \code{"int"}, \code{"ext"} or
\code{"all"}, directing the crawler to follow only internal links, follow only external links (different domain to
the seed page) or follow all links. The \code{max_depth} value determines how many levels of hyperlinks to follow
from the seed site.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A \code{tibble} object with class names \code{"datasource"} and \code{"web"}.
}
\description{
Collects hyperlinks from web pages and structures the data into a dataframe with the class names
\code{"datasource"} and \code{"web"}.
}
\examples{
\dontrun{
pages <- tibble::tibble(page = c("http://vosonlab.net",
                                 "https://rsss.cass.anu.edu.au"),
                        type = c("int", "all"),
                        max_depth = c(2, 2))

webData <- webAuth |>
  Collect(pages, writeToFile = TRUE)
}

}
